import { Request, Response } from "express";
import { AuthService } from "../services/auth.service";

export class AuthController {
  static async login(req: Request, res: Response): Promise<void> {
    try {
      const { email, password } = req.body;
      if (!email || !password) {
        res.status(400).json({ error: "Email and password required" });
        return;
      }

      const result = await AuthService.login(email, password);
      res.status(200).json(result);
    } catch (error: any) {
      if (error.message === "Invalid credentials") {
        res.status(401).json({ error: error.message });
        return;
      }
      console.error("Login Error:", error);
      res.status(500).json({ error: "Internal Server Error" });
    }
  }

  static async updateCredentials(req: Request, res: Response): Promise<void> {
    try {
      const { newEmail, newPassword } = req.body;
      // req.user is populated by the auth middleware
      const userId = (req as any).user.userId;

      if (!newEmail && !newPassword) {
        res
          .status(400)
          .json({ error: "Provide newEmail or newPassword to update" });
        return;
      }

      const result = await AuthService.updateCredentials(
        userId,
        newEmail,
        newPassword,
      );
      res
        .status(200)
        .json({ message: "Credentials updated successfully", user: result });
    } catch (error: any) {
      if (error.message === "Email already in use") {
        res.status(400).json({ error: error.message });
        return;
      }
      console.error("Update Credentials Error:", error);
      res.status(500).json({ error: "Internal Server Error" });
    }
  }
}
