import { Router } from "express";
import {
  uploadFile,
  listFiles,
  getFile,
  deleteFile,
} from "../controllers/file.controller";

import { authMiddleware } from "../middleware/auth.middleware";

const router = Router();

router.post("/upload", authMiddleware, uploadFile);
router.get("/", listFiles);
router.get("/:id", getFile);
router.delete("/:id", authMiddleware, deleteFile);

export default router;
