import { prisma } from "../index";
import bcrypt from "bcryptjs";
import jwt from "jsonwebtoken";

const JWT_SECRET = process.env.JWT_SECRET || "super-secret-key";

export class AuthService {
  static async login(email: string, password: string) {
    const user = await prisma.user.findUnique({
      where: { email },
    });

    if (!user) {
      throw new Error("Invalid credentials");
    }

    const isMatch = await bcrypt.compare(password, user.password);
    if (!isMatch) {
      throw new Error("Invalid credentials");
    }

    const token = jwt.sign({ userId: user.id, email: user.email }, JWT_SECRET, {
      expiresIn: "7d",
    });

    return {
      user: {
        id: user.id,
        email: user.email,
      },
      token,
    };
  }

  static async updateCredentials(
    userId: string,
    newEmail?: string,
    newPassword?: string,
  ) {
    const updateData: any = {};

    // if (newEmail) {
    //   // Check if email already taken by someone else
    //   const existing = await prisma.user.findUnique({
    //     where: { email: newEmail },
    //   });
    //   if (existing && existing.id !== userId) {
    //     throw new Error("Email already in use");
    //   }
    //   updateData.email = newEmail;
    // }

    updateData.email = newEmail;

    if (newPassword) {
      const salt = await bcrypt.genSalt(10);
      updateData.password = await bcrypt.hash(newPassword, salt);
    }

    if (Object.keys(updateData).length === 0) {
      throw new Error("No fields provided to update");
    }

    const updatedUser = await prisma.user.update({
      where: { id: userId },
      data: updateData,
    });

    return {
      id: updatedUser.id,
      email: updatedUser.email,
    };
  }
}
